#include <stdio.h>
 
#define MAX_SIZE 2000000
#define UNDEF_TIME -1
 
char buffer[MAX_SIZE + 1];
 
int addDq[MAX_SIZE];
int addBegin, addEnd;
 
int matchTime[MAX_SIZE];
 
int lastBad = -1;
 
int realBegin, realEnd;
 
int getBalance() {
    return addBegin == addEnd && lastBad < realBegin;
}
 
void add(char t) {
    matchTime[realEnd] = UNDEF_TIME;
    if (t == '(') {
        addDq[addEnd++] = realEnd;
    } else {
        if (addBegin == addEnd) {
            lastBad = realEnd;
        } else {
            matchTime[addDq[--addEnd]] = realEnd;
        }
    }
    ++realEnd;
}
 
void pop() {
    addBegin += addBegin != addEnd && addDq[addBegin] == realBegin;
    int erasedValue = matchTime[realBegin];
    if (lastBad < erasedValue) {
        lastBad = erasedValue;
    }
    ++realBegin;
}
 
int main() {
    FILE* f = fopen("balans2.in", "r");
    int n;
    fscanf(f, "%d\n", &n);
    fgets(buffer, n + 1, f);
    fclose(f);
 
    f = fopen("balans2.out", "w");
    for (int i = 0; i < n; ++i) {
        if (buffer[i] == 'P') {
            pop();
        } else {
            add(buffer[i]);
        }
        buffer[i] = getBalance() + '0';
    }
    fputs(buffer, f);
    fclose(f);
}
